//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1994
// 
// ServerUNIX.cc -- Server for UNIX/stream socket test. Server accepts multiple
// connections from clients. Each client then communicates with an acceptor.
// The acceptor reads the data from the client and writes it back.
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:40:22 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Sep  2 09:21:56 2006
// Update Count     : 138
// 

#include <uC++.h>
#include <uSocket.h>
#include <iostream>
using std::cerr;
using std::osacquire;
using std::endl;

#define EOD '\377'
#define BufferSize (8 * 1024)

_Task server;											// forward declaration

_Task acceptor {
	uSocketServer &sockserver;
	server &s;

	void main();
  public:
	acceptor( uSocketServer &socks, server &s ) : uBaseTask( 64000 ), sockserver( socks ), s( s ) {
	} // acceptor::acceptor
}; // acceptor

_Task server {
	uSocketServer &sockserver;
	acceptor *terminate;
	int acceptorCnt;
	bool timeout;
  public:
	server( uSocketServer &socks ) : sockserver( socks ), acceptorCnt( 1 ), timeout( false ) {
	} // server::server

	void connection() {
	} // server::connection

	void complete( acceptor *terminate, bool timeout ) {
		server::terminate = terminate;
		server::timeout = timeout;
	} // server::complete
  private:
	void main() {
		new acceptor( sockserver, *this );				// create initial acceptor
		for ( ;; ) {
			_Accept( connection ) {
				new acceptor( sockserver, *this );		// create new acceptor after a connection
				acceptorCnt += 1;
			} else _Accept( complete ) {				// acceptor has completed with client
				delete terminate;						// delete must appear here or deadlock
				acceptorCnt -= 1;
		  if ( acceptorCnt == 0 ) break;				// if no outstanding connections, stop
				if ( timeout ) {
					new acceptor( sockserver, *this );	// create new acceptor after a timeout
					acceptorCnt += 1;
				} // if
			}; // _Accept
		} // for
	} // server::main
}; // server

void acceptor::main() {
	try {
		uDuration timeout( 10, 0 );						// timeout for accept
		uSocketAccept acceptor( sockserver, &timeout );	// accept a connection from a client
		char buf[BufferSize];
		int len;

		s.connection();									// tell server about client connection
		for ( ;; ) {
			len = acceptor.read( buf, sizeof(buf) );	// read byte from client
			// osacquire( cerr ) << "Server::acceptor read len:" << len << endl;
		  if ( len == 0 ) uAbort( "(uSocketAccept &)0x%p : EOF ecountered without EOD", &acceptor );
			acceptor.write( buf, len );					// write byte back to client
			// The EOD character can be piggy-backed onto the end of the message.
		  if ( buf[len - 1] == EOD ) break;				// end of data ?
		} // for
		s.complete( this, false );						// terminate
	} catch( uSocketAccept::OpenTimeout ) {
		s.complete( this, true );						// terminate
	} // try
} // acceptor::main

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		cerr << "Usage: " << argv[0] << " socket-name" << endl;
		exit( -1 );
	} // switch

	uSocketServer sockserver( argv[1] );				// create and bind a server socket
	{
		server s( sockserver );							// execute until acceptor times out
	}
} // uMain

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Server ServerUNIX.cc" //
// End: //
