//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1999
// 
// ServerINET2.cc -- Server for INET/datagram socket test. Server reads data
// from multiple clients. The server reads the data from the client and writes
// it back.
// 
// Author           : Peter A. Buhr
// Created On       : Thu Apr 29 16:02:50 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Sep  2 09:21:33 2006
// Update Count     : 31
// 

#include <uC++.h>
#include <uSocket.h>
#include <iostream>
using std::cout;
using std::cerr;
using std::osacquire;
using std::endl;

#define EOD '\377'
#define BufferSize (8 * 1024)

_Task reader {
    uSocketServer &server;

    void main() {
		uDuration timeout( 10, 0 );						// timeout for read
        char buf[BufferSize];
		int len;

		try {
			for ( ;; ) {
				len = server.recvfrom( buf, sizeof(buf), 0, &timeout );
				// osacquire( cerr ) << "Server::reader read len:" << len << endl;
			  if ( len == 0 ) uAbort( "(uSocketServer &)0x%p : EOF ecountered without EOD", &server );
				server.sendto( buf, len );				// write byte back to client
			} // for
		} catch( uSocketServer::ReadTimeout ) {
		} // try
    } // reader::main
  public:
    reader( uSocketServer &server ) : uBaseTask( 64000 ), server( server ) {
    } // reader::reader
}; // reader

void uMain::main() {
	switch ( argc ) {
	  case 1:
		break;
	  default:
		cerr << "Usage: " << argv[0] << endl;
		exit( -1 );
	} // switch

	short unsigned int port;
	uSocketServer server( &port, SOCK_DGRAM );			// create and bind a server socket to free port

	cout << port << endl;								// print out free port for clients
	{
		reader rd( server );							// execute until EOD
	}
} // uMain

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Server ServerINET2.cc" //
// End: //
