//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1994
// 
// File.cc -- Print multiple copies of the same file to standard output
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:44:56 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Sep  2 09:20:34 2006
// Update Count     : 42
// 

#include <uC++.h>
#include <uFile.h>
#include <iostream>
using std::cout;
using std::cerr;
using std::endl;

_Task Copier {
	uFile &input;

	void main() {
		uFileAccess in( input, O_RDONLY );
		int count;
		char buf[1];

		for ( int i = 0;; i += 1 ) {					// copy in-file to out-file
			count = in.read( buf, sizeof( buf ) );
		  if ( count == 0 ) break;						// eof ?
			cout << buf[0];
			if ( i % 20 == 0 ) yield();
		} // for
	} // Copier::main
  public:
	Copier( uFile &in ) : input( in ) {
	} // Copier::Copier
}; // Copier

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		cerr << "Usage: " << argv[0] << " input-file" << std::endl;
		exit( -1 );
	} // switch

	uFile input( argv[1] );								// connect with UNIX files
	{
		Copier c1( input ), c2( input );
	}
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ File.cc" //
// End: //
