//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 2003
// 
// EHM9.cc -- recursive resumption
// 
// Author           : Peter A. Buhr
// Created On       : Sun Dec  7 12:15:30 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Nov 21 15:26:01 2005
// Update Count     : 33
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_ResumeEvent R1 {};
_ResumeEvent R2 {};


void H1( R2 ) {
	osacquire( cout ) << "enter H1" << endl;
	osacquire( cout ) << "exit  H1" << endl;
} // H1

void H2( R1 ) {
	osacquire( cout ) << "enter H2" << endl;
	_Resume R2();
	osacquire( cout ) << "exit  H2" << endl;
} // H2

void H3( R2 ) {
	osacquire( cout ) << "enter H3" << endl;
	_Resume R1();
	osacquire( cout ) << "exit  H3" << endl;
} // H3


// Checks marking of handlers is performed correctly during propagation.
// Marking prevents recursive resumption.

void uMain::main () {
	try <R2, H1> {
		try <R1, H2> {
			try <R2, H3> {
				osacquire( cout ) << "before raise" << endl;
				_Resume R1();
				osacquire( cout ) << "after raise" << endl;
			} // try
		} // try
	} // try
	osacquire( cout ) << "finished" << endl;
} // uMain::main


// Local Variables: //
// tab-width: 4 //
// End: //
