//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Roy Krischer 2002
// 
// EHM4.cc -- 
// 
// Author           : Roy Krischer
// Created On       : Tue Mar 26 23:01:30 2002
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep 12 08:08:45 2006
// Update Count     : 139
// 

#include <uC++.h>
#include <uBarrier.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

#define MAX 1000
#define NTASK 5
#define ROUNDS 10000


_Task worker {
    int id, round;

	void main();
  public:
    worker ( int id ) : id(id), round(ROUNDS) {
		osacquire( cout ) << "task " << this << " creation" << endl;
	} 
    ~worker() {
		osacquire( cout ) << "task " << this << " destruction" << endl;
    }
}; // worker


_Monitor atomicCnt {
    int c;
  public:
    atomicCnt( int c = -1 ) : c(c) {}

    int inc() {
		c += 1;
		return c;
    } // inc
}; // atomicCnt


atomicCnt cnt;											// atomic counter
int array[NTASK*((NTASK-1)*ROUNDS+1)] = {0};			// check for duplicate handling
int handled[NTASK] = {0};								// count exceptions handled per task
uBarrier b( NTASK + 1 );								// control start and finish of main/worker tasks
worker *f[NTASK];										// shared resource controlled by barrier


_ResumeEvent rev {
  public:
    int ticket;
    rev( const char *msg, int ticket ) : uResumeClass(msg), ticket(ticket) {};
};

class Arg {
    int &id, &round;
  public:
    Arg( int &id, int &round ) : id(id), round(round) {}
	void operator()( rev &r ) {
		handled[id] += 1;								// count exceptions handled by each task
		//osacquire( cerr ) << "handler, exception id: " << e.ticket << endl;
		assert( r.ticket < NTASK*((NTASK-1)*ROUNDS+1) ); // subscript error ?
		array[r.ticket] += 1;
		if ( array[r.ticket] > 1 ) uAbort( "error - same exception handled twice");
		if ( round != 0 ) {								// only a subset of exceptions raise more
			round -= 1;
			if ( round % 2 == 0 ) {						// generate 1/2 of the exceptions
				for ( int i = 0; i < NTASK; i += 1 ) {	// send exceptions to other tasks
					if ( i != id ) {					// except myself
						_Resume rev( "other", cnt.inc() ) _At *f[i];
					} // if
				} // for
			} // if
		} // if
	}
}; // Arg


void worker::main() {
	Arg arg( id, round );

    b.block();											// wait for all tasks to start
	osacquire( cout ) << "task " << this << " starting" << endl;
	yield( NTASK );

	try <rev, arg> {
		_Enable {
			_Resume rev( "self", cnt.inc() ) _At *this; // initial resume at myself
			for ( int n = 0; n < ROUNDS / 2; n += 1 ) {	// generate other 1/2 of the exceptions
				yield();								// allow delivery of concurrent resumes
				for ( int i = 0; i < NTASK; i += 1 ) {	// send exceptions to other tasks
					if ( i != id ) {					// except myself
						_Resume rev( "other", cnt.inc() ) _At *f[i];
					} // if
				} // for
			} // for
		} // _Enable
	} // try

    b.block();											// wait for all tasks to finish
	osacquire( cout ) << "task " << this << " finishing" << endl;
} // worker::main


void uMain::main () {
    uProcessor p[4];

    for ( int i = 0; i < NTASK; i += 1 ) {
		f[i] = new worker( i );
    } // for
    b.block();											// wait for all tasks to start

    b.block();											// wait for all tasks to finish
	int total = 0;
    for ( int i = 0; i < NTASK; i += 1 ) {
		delete f[i];
		total += handled[i];							// sum exceptions handled by each task
    } // for
	osacquire( cout ) << "cnt:" << cnt.inc() << "  handled:" << total << endl;
} // uMain::main


// Local Variables: //
// tab-width: 4 //
// End: //
