//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.1, Copyright (C) Peter A. Buhr 1997
// 
// EHM1.cc -- testing exception handling mechanism
// 
// Author           : Peter A. Buhr
// Created On       : Wed Nov 26 23:06:25 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Aug  6 17:47:33 2005
// Update Count     : 238
// 


#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;


//######################### uBaseCoroutine::uFailure #########################


_ThrowEvent xxx {
  public:
    xxx( const char *const msg ) : uEHM::uThrowClass( msg ) {}
};


_Coroutine CoroutineDummy1 {
    void main() {
	_Throw xxx( "test" );
    } // CoroutineDummy1::main
  public:
    void mem() { resume(); }
}; // CoroutineDummy1

_Coroutine CoroutineDummy2 {
    void main() {
	CoroutineDummy1 dummy1;
	dummy1.mem();
    } // CoroutineDummy1::main
  public:
    void mem() { resume(); }
}; // CoroutineDummy1


//######################### uCondition::uWaitingFailure #########################


_Task TaskDummy1 {
    uCondition x;
  public:
    void mem() {
	x.wait();
    } // TaskDummy1::mem
  private:
    void main() {
	_Accept( mem );
    } // TaskDummy1::main
}; // TaskDummy1

_Task TaskDummy2 {
    TaskDummy1 &t1;

    void main() {
#if 0
	t1.mem();
#endif
	try {
	    t1.mem();
	} catch( uCondition::WaitingFailure &evt ) {
	    osacquire( cout ) << "handled exception uCondition::WaitingFailure : task " << evt.source().getName() << " (" << &(evt.source()) << ") found blocked task" << " " << uThisTask().getName() << " (" << &uThisTask() << ") on condition variable " << &evt.conditionId() << endl << endl;
	} // try
    } // TaskDummy2::main
  public:
    TaskDummy2( TaskDummy1 &t1 ) : t1( t1 ) {}
}; // TaskDummy2


//######################### uSerial::uRendezvousFailure #########################


_Task TaskDummy3 {
    uBaseTask &t;
  public:
    TaskDummy3( uBaseTask &t ) : t( t ) {}
    void mem() {
    } // TaskDummy3::mem
  private:
    void main() {
	_Throw xxx( "test" ) _At t;
#if 0
	_Accept( mem );
#endif
	try {
	    _Accept( mem );
	} catch ( uSerial::RendezvousFailure &evt ) {
	    osacquire( cout ) << "handled exception uSerial::RendezvousFailure : accepted call fails from task " << evt.sourceName() << " (" << &(evt.source()) << ") to mutex member of task " << uThisTask().getName() << " (" << &uThisTask() << ")" << endl << endl;
	} // try
    } // TaskDummy3::main
}; // TaskDummy3


//######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################


_Task TaskDummy4 {
    uCondition temp;
  public:
    void mem() {
	temp.wait();
    } // TaskDummy4::mem
  private:
    void main() {
	_Accept( mem );				// let TaskDummy5 in so it can wait
	temp.signal();					// put TaskDummy5 on A/S stack
	_Accept( ~TaskDummy4 );			// uMain is calling the destructor
    } // TaskDummy4::main
}; // TaskDummy4

_Task TaskDummy5 {
    TaskDummy4 &t4;
  public:
    TaskDummy5( TaskDummy4 &t4 ) : t4( t4 ) {}
  private:
    void main() {
#if 0
	t4.mem();
#endif
	try {
	    t4.mem();
	} catch( uSerial::EntryFailure &evt ) {
	    osacquire( cout ) << "handled exception uSerial::EntryFailure : while executing mutex destructor, task " << evt.source().getName() << " (" << &(evt.source()) << ") found task " << uThisTask().getName() << " (" << &uThisTask() << ") " << evt.message() << endl << endl;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    } // TaskDummy5::main
}; // TaskDummy5


//######################### uSerial::uEntryFailure (entry queue) #########################


_Task TaskDummy6 {
  public:
    void mem() {
    } // TaskDummy6::mem
  private:
    void main() {
	_Accept( ~TaskDummy6 );
    } // TaskDummy6::main
};

_Task TaskDummy7 {
    TaskDummy6 &t6;
  public:
    TaskDummy7( TaskDummy6 &t6 ) : t6( t6 ) {}
  private:
    void main() {
#if 0
	t6.mem();
#endif
	try {
	    t6.mem();
	} catch( uSerial::EntryFailure &evt ) {
	    osacquire( cout ) << "handled exception uSerial::EntryFailure : while executing mutex destructor, task " << evt.source().getName() << " (" << &(evt.source()) << ") found task " << uThisTask().getName() << " (" << &uThisTask() << ") " << evt.message() << endl << endl;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    } // TaskDummy7::main
}; // TaskDummy7


void uMain::main() {
    //######################### uBaseCoroutine::UnHandledException #########################
    {
	CoroutineDummy1 dummy1;

	try {
	    dummy1.mem();
	} catch( uBaseCoroutine::UnHandledException &evt ) {
	    osacquire( cout ) << "handled exception uBaseCoroutine::UnHandledException : in coroutine " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") raised non-locally from resumed coroutine " << evt.sourceName() << " (" << &(evt.source()) << "), which was terminated due to an " << evt.message() << endl << endl;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    {
	CoroutineDummy2 dummy2;

	try {
	    dummy2.mem();
	} catch( uBaseCoroutine::UnHandledException &evt ) {
	    osacquire( cout ) << "handled exception uBaseCoroutine::UnHandledException : in coroutine " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") raised non-locally from resumed coroutine " << evt.sourceName() << " (" << &(evt.source()) << "), which was terminated due to a series of unhandled exceptions -- originally " << evt.message() << " inside coroutine " << evt.origName() << " (" << &(evt.origSource()) << ")." << endl << endl;
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    //######################### uCondition::uWaitingFailure #########################

    TaskDummy1 *t1 = new TaskDummy1;
    TaskDummy2 *t2 = new TaskDummy2( *t1 );
    delete t1;						// delete t1 with t2 blocked on condition variable
    delete t2;

    //######################### uSerial::uRendezvousFailure #########################
    {
	TaskDummy3 t3( uThisTask() );
	try {
	    _Enable {
		t3.mem();
	    } // _Enable
	} catch( xxx &evt ) {
	} catch( ... ) {
	    uAbort( "error" );
	} // try
    }
    //######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################

    TaskDummy4 *t4 = new TaskDummy4;
    TaskDummy5 *t5 = new TaskDummy5( *t4 );
    delete t4;
    delete t5;

    //######################### uSerial::uEntryFailure (entry queue) #########################

    TaskDummy6 *t6 = new TaskDummy6;
    TaskDummy7 *t7 = new TaskDummy7( *t6 );
    delete t6;
    delete t7;

    cout << "successful execution" << endl;
} // uMain::main
