//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1994
// 
// scan.c -- 
// 
// Author           : Richard A. Stroobosscher
// Created On       : Tue Apr 28 15:11:49 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Aug  8 07:15:40 2004
// Update Count     : 49
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#include "hash.h"
#include "token.h"
#include "table.h"
#include "input.h"
#include "scan.h"


void scan() {
    ahead = ahead->next_parse_token();

    if ( ahead->value == EOF ) return;

    if ( ahead->hash->value != 0 ) {
	// if the value of the hash associated with the look ahead token is non
	// zero, it must be a keyword.  simply make the value of the token the
	// value of the keyword.
	
	ahead->value = ahead->hash->value;
    } else if ( ahead->symbol != NULL ) {
	// symbol has already been looked up and the parser has backtracked to
	// it again.
    } else if ( ahead->value == IDENTIFIER ) {
	// use the symbol to determine whether the identifier is a type or a
	// variable.
	
	if ( focus != NULL ) {			// scanning mode
	    ahead->symbol = focus->search_table( ahead->hash );
	    if ( ahead->symbol != NULL ) {
		ahead->value = ahead->symbol->value;
	    } // if
	} // if
    } // if
} // scan

// Local Variables: //
// compile-command: "gmake install" //
// End: //
