//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 1994
// 
// uPoll.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 17:02:07 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jan 24 18:15:32 2006
// Update Count     : 39
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#include <uPoll.h>

#include <sys/stat.h>
#include <fcntl.h>


void uPoll::setPollFlag( int fd ) {
    int flags;

    for ( ;; ) {
	flags = ::fcntl( fd, F_GETFL, 0 );
      if ( flags != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    if ( flags == -1 ) {
	uStatus = NeverPoll;
    } else {
	for ( ;; ) {
	    flags = ::fcntl( fd, F_SETFL, flags | U_FNDELAY );
	  if ( flags != -1 ) break;
	  if ( errno != EINTR ) break;			// timer interrupt ?
	} // for
	if ( flags == -1 ) {
	    uStatus = NeverPoll;
	} // if
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPoll &)0x%p.setPollFlag( %d ), uStatus:%d\n", this, fd, uStatus );
#endif // __U_DEBUG_H__
} // uPoll::setPollFlag


void uPoll::clearPollFlag( int fd ) {
    int flags;

    for ( ;; ) {
	flags = ::fcntl( fd, F_GETFL, 0 );
      if ( flags != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    if ( flags == -1 ) {
	uStatus = NeverPoll;
    } else {
	for ( ;; ) {
	    flags = ::fcntl( fd, F_SETFL, flags & ~ U_FNDELAY );
	  if ( flags != -1 ) break;
	  if ( errno != EINTR ) break;			// timer interrupt ?
	} // for
	if ( flags == -1 ) {
	    uStatus = NeverPoll;
	} // if
    } // if
} // uPoll::clearPollFlag


void uPoll::computeStatus( int fd ) {
    struct stat buf;
    int flags;

    for ( ;; ) {
	flags = ::fstat( fd, &buf );
      if ( flags != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPoll &)0x%p.computeStatus( %d ), flags:%d, st_mode:0x%x\n", this, fd, flags, buf.st_mode );
#endif // __U_DEBUG_H__
    if ( flags ) {
	uStatus = NeverPoll;				// if the file cannot be stat'ed, never poll
    } else if ( S_ISCHR(buf.st_mode) ) {
	uStatus = PollOnDemand;				// if a tty, poll on demand
#ifdef S_IFIFO
    } else if ( S_ISFIFO(buf.st_mode) ) {
	uStatus = AlwaysPoll;				// if a pipe, always poll
#endif
    } else if ( S_ISSOCK(buf.st_mode) ) {
	uStatus = AlwaysPoll;				// if a socket, always poll
    } else {
	uStatus = NeverPoll;				// otherwise, never
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPoll &)0x%p.computeStatus( %d ), uStatus:%d\n", this, fd, uStatus );
#endif // __U_DEBUG_H__
} // uPoll::computeStatus


void uPoll::setStatus( PollStatus s ) {
    uStatus = s;
} // uPoll::setStatus


uPoll::PollStatus uPoll::getStatus() {
    return uStatus;
} // uPoll::getStatus


// Local Variables: //
// compile-command: "gmake install" //
// End: //
