//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 2005
// 
// fstream.h -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jul 19 13:24:20 2005
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Sep 16 13:51:45 2005
// Update Count     : 14
// 
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __FSTREAM_H__
#define __FSTREAM_H__


#include <iosfwd>
#include <istream>
#include <ostream>

#include <uFilebuf.h>

#pragma __U_NOT_USER_CODE__


namespace std {


//######################### ifstream #########################


template< class Ch, class Tr >
class basic_ifstream : public std::basic_istream<Ch, Tr> {
    basic_filebuf<Ch,Tr> sb;
  public:
    basic_ifstream();
    basic_ifstream( const char *name, std::ios_base::openmode mode = std::ios_base::in );
    bool is_open();
    void open( const char *name, std::ios_base::openmode mode = std::ios_base::in );
    void close();
    basic_filebuf<Ch,Tr> *rdbuf() const;
}; // basic_ifstream


//######################### ofstream #########################


template< class Ch, class Tr >
class basic_ofstream : public std::basic_ostream<Ch, Tr> {
    basic_filebuf<Ch,Tr> sb;
  public:
    basic_ofstream();
    basic_ofstream( const char *name, std::ios_base::openmode mode = std::ios_base::out );
    bool is_open();
    void open( const char *name, std::ios_base::openmode mode = std::ios_base::out );
    void close();
    basic_filebuf<Ch,Tr> *rdbuf();
}; // basic_ofstream


//######################### fstream #########################


template< class Ch, class Tr >
class basic_fstream : public std::basic_iostream<Ch, Tr> {
    basic_filebuf<Ch,Tr> sb;
  public:
    basic_fstream();
    basic_fstream( const char *name, ios_base::openmode mode = ios_base::in | ios_base::out );
    bool is_open();
    void open( const char *name, ios_base::openmode mode = ios_base::in | ios_base::out );
    void close();
    basic_filebuf<Ch,Tr> *rdbuf();
}; // basic_fstream


//######################### ifstream #########################


template< class Ch, class Tr >
basic_ifstream<Ch, Tr>::basic_ifstream() : std::basic_istream<Ch, Tr>( &sb ) {
} // ifstream<Ch, Tr>::ifstream

template< class Ch, class Tr >
basic_ifstream<Ch, Tr>::basic_ifstream( const char *name, std::ios_base::openmode mode ) : std::basic_istream<Ch, Tr>( &sb ) {
    rdbuf()->open( name, mode );
} // ifstream<Ch, Tr>::ifstream

template< class Ch, class Tr >
bool basic_ifstream<Ch, Tr>::is_open() {
    return rdbuf()->is_open();
} // ifstream<Ch, Tr>::is_open

template< class Ch, class Tr >
void basic_ifstream<Ch, Tr>::open( const char *name, std::ios_base::openmode mode ) {
    rdbuf()->open( name, mode );
} // ifstream<Ch, Tr>::ifstream

template< class Ch, class Tr >
void basic_ifstream<Ch, Tr>::close() {
    rdbuf()->close();
} // ifstream<Ch, Tr>::close

template< class Ch, class Tr >
basic_filebuf<Ch,Tr> *basic_ifstream<Ch, Tr>::rdbuf() const {
    return (basic_filebuf<Ch,Tr> *)std::basic_istream<Ch, Tr>::rdbuf();
} // ifstream<Ch, Tr>::rdbuf


//######################### ofstream #########################


template< class Ch, class Tr >
basic_ofstream<Ch, Tr>::basic_ofstream() : std::basic_ostream<Ch, Tr>( &sb ) {
} // ofstream<Ch, Tr>::ofstream

template< class Ch, class Tr >
basic_ofstream<Ch, Tr>::basic_ofstream( const char *name, std::ios_base::openmode mode ) : std::basic_ostream<Ch, Tr>( &sb ) {
    rdbuf()->open( name, mode );
} // ofstream<Ch, Tr>::ofstream

template< class Ch, class Tr >
bool basic_ofstream<Ch, Tr>::is_open() {
    return rdbuf()->is_open();
} // ofstream<Ch, Tr>::is_open

template< class Ch, class Tr >
void basic_ofstream<Ch, Tr>::open( const char *name, std::ios_base::openmode mode ) {
    rdbuf()->open( name, mode );
} // ofstream<Ch, Tr>::ofstream

template< class Ch, class Tr >
void basic_ofstream<Ch, Tr>::close() {
    rdbuf()->close();
} // ofstream<Ch, Tr>::close

template< class Ch, class Tr >
basic_filebuf<Ch,Tr> *basic_ofstream<Ch, Tr>::rdbuf() {
    return (basic_filebuf<Ch,Tr> *)std::basic_ostream<Ch, Tr>::rdbuf();
} // ofstream<Ch, Tr>::rdbuf


//######################### fstream #########################


template< class Ch, class Tr >
basic_fstream<Ch, Tr>::basic_fstream() : std::basic_iostream<Ch, Tr>( &sb ) {
} // fstream<Ch, Tr>::fstream

template< class Ch, class Tr >
basic_fstream<Ch, Tr>::basic_fstream( const char *name, std::ios_base::openmode mode ) : std::basic_iostream<Ch, Tr>( &sb ) {
    rdbuf()->open( name, mode );
} // fstream<Ch, Tr>::fstream

template< class Ch, class Tr >
bool basic_fstream<Ch, Tr>::is_open() {
    return rdbuf()->is_open();
} // fstream<Ch, Tr>::is_open

template< class Ch, class Tr >
void basic_fstream<Ch, Tr>::open( const char *name, std::ios_base::openmode mode ) {
    rdbuf()->open( name, mode );
} // fstream<Ch, Tr>::fstream

template< class Ch, class Tr >
void basic_fstream<Ch, Tr>::close() {
    rdbuf()->close();
} // fstream<Ch, Tr>::close

template< class Ch, class Tr >
basic_filebuf<Ch,Tr> *basic_fstream<Ch, Tr>::rdbuf() {
    return (basic_filebuf<Ch,Tr> *)std::basic_iostream<Ch, Tr>::rdbuf();
} // fstream<Ch, Tr>::rdbuf


} // namespace std


#pragma __U_USER_CODE__

#endif // __FSTREAM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
