	.file	"uKernelThreads.S"
	.pred.safe_across_calls p1-p5,p16-p63
	.text

#ifdef __U_TLS__

#define GETMEM_BODY( op ) \
	.prologue ; \
	alloc r16 = ar.pfs, 1, 0, 2, 0 ; \
	.body ; \
	cmp.eq p7, p0 = r0, r0 ; \
	add r14 = @tprel(_ZN13uKernelModule17uKernelModuleBootE#), r32 ; \
	fetchadd8.acq r15 = [r13], 1;; ; \
	add r14 = r13, r14;; ; \
	op r32 = [r14];; ; \
	fetchadd8.rel r15 = [r13], -1 ; \
	(p7) br.cond.sptk.many label_##op;; ; \
	mov r15 = 1105 ; \
	break 0x100000;; ; \
	mov r15 = 1229 ; \
	mov r33 = r8 ; \
	mov r34 = 10 ; \
	break.i 0x100000;; ; \
	label_##op: \
	mov r8 = r32 ; \
	br.ret.sptk.many b0

#define SETMEM_BODY( op ) \
	.prologue ; \
	alloc r16 = ar.pfs, 2, 0, 2, 0 ; \
	.body ; \
	cmp.eq p7, p0 = r0, r0 ; \
	add r14 = @tprel(_ZN13uKernelModule17uKernelModuleBootE#), r32 ; \
	fetchadd8.acq r15 = [r13], 1;; ; \
	add r14 = r13, r14;; ; \
	op [r14] = r33;; ; \
	fetchadd8.rel r14 = [r13], -1 ; \
	(p7) br.ret.sptk.many b0;; ; \
	mov r15 = 1105 ; \
	break 0x100000;; ; \
	mov r15 = 1229 ; \
	mov r33 = r8 ; \
	mov r34 = 10 ; \
	break.i 0x100000;; ; \
	br.ret.sptk.many b0

#else

#define SIZEOF_KERNELMODULE 72

#define GETMEM_BODY( op ) \
	.prologue ; \
	alloc r16 = ar.pfs, 1, 0, 2, 0 ; \
	.body ; \
	adds r32 = 16 - SIZEOF_KERNELMODULE, r32 ; \
	cmp.eq p7, p0 = r0, r0 ; \
	fetchadd8.acq r14 = [r13], 1;; ; \
	add r15 = r32, r13;; ; \
	op r32 = [r15] ; \
	;;fetchadd8.rel r14 = [r13], -1 ; \
	(p7) br.cond.sptk.many label_##op;; ; \
	mov r15 = 1041 ; \
	break 0x100000;; ; \
	mov r15 = 1053 ; \
	mov out0 = r8 ; \
	mov out1 = 14 ; \
	break 0x100000;; ; \
	label_##op: \
	mov r8 = r32 ; \
	br.ret.sptk.many b0

#define SETMEM_BODY( op ) \
	.prologue ; \
	alloc r16 = ar.pfs, 2, 0, 2, 0 ; \
	.body ; \
	adds r32 = 16 - SIZEOF_KERNELMODULE, r32 ; \
	cmp.eq p7, p0 = r0, r0 ; \
	fetchadd8.acq r14 = [r13], 1;; ; \
	add r15 = r32, r13;; ; \
	st4 [r15] = r33 ; \
	fetchadd8.rel r14 = [r13], -1 ; \
	(p7) br.ret.sptk.many b0;; ; \
	mov r15 = 1041 ; \
	break 0x100000;; ; \
	mov r15 = 1053 ; \
	mov out0 = r8 ; \
	mov out1 = 14 ; \
	break 0x100000;; ; \
	br.ret.sptk.many b0

#endif

	.global _ZN13uKernelModule17uKernelModuleBootE#

	.align 16
	.global thread_getmem_1#
	.proc thread_getmem_1#
thread_getmem_1:
GETMEM_BODY( ld1 )
	.endp thread_getmem_1#


	.align 16
	.global thread_getmem_4#
	.proc thread_getmem_4#
thread_getmem_4:
GETMEM_BODY( ld4 )
	.endp thread_getmem_4#


	.align 16
	.global thread_getmem_8#
	.proc thread_getmem_8#
thread_getmem_8:
GETMEM_BODY( ld8 )
	.endp thread_getmem_8#


	.align 16
	.global thread_setmem_1#
	.proc thread_setmem_1#
thread_setmem_1:
SETMEM_BODY( st1 )
	.endp thread_setmem_1#


	.align 16
	.global thread_setmem_4#
	.proc thread_setmem_4#
thread_setmem_4:
SETMEM_BODY( st4 )
	.endp thread_setmem_4#


	.align 16
	.global thread_setmem_8#
	.proc thread_setmem_8#
thread_setmem_8:
SETMEM_BODY( st8 )
	.endp thread_setmem_8#
