//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 1994
// 
// uAtomic.h -- test-and-set routines for various processors
// 
// Author           : Richard C. Bilson
// Created On       : Thu Sep 16 13:57:26 2004
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Jan  4 13:59:47 2006
// Update Count     : 9
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

#if defined( __ia64__ )
#include <ia64intrin.h>
#endif // __ia64__


inline int uAtomic( unsigned int *lock ) {
#if defined( __sparc__ )
    int result = 1;
    asm( "ldstub %1, %0" : "+r" (result), "+m" (*lock) );
    return result;
#elif defined( __i386__ ) || defined( __x86_64__ )
    int result = 1;
    asm( "xchgl %0,%1" : "+q" (result), "+m" (*lock) );
    return result;
#elif defined( __ia64__ )
    return __sync_lock_test_and_set( lock, 1 );
#elif defined( __mips__ )
    int result;
    bool success;
    do {
	asm( "ll   %0,%2\n\t"
	      "or   %1,%0,1\n\t"
	      "sc   %1,%2"
	      : "=&r" (result), "=&r" (success), "+m" (*lock) );
    } while ( ! success );
    return result;
#else
    #error uC++ : internal error, unsupported architecture
#endif
} // uAtomic
