//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 1994
// 
// uCalibrate.cc -- Calibrate the number of iterations of a set piece of code
//    to produce a 100 microsecond delay.
// 
// Author           : Peter A. Buhr
// Created On       : Fri Aug 16 14:12:08 1991
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Jul 31 18:53:16 2005
// Update Count     : 21
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::endl;

#include "Time.h"

#define TIMES 10000000					// cannot be larger or overflow occurs

void uMain::main() {
    volatile int i;
    int StartTime, EndTime;
    
    StartTime = Time();
    for ( i = 1; i <= TIMES; i += 1 ) {
    } // for
    EndTime = Time();

    cout << "#define ITERATIONS_FOR_100USECS " << ( 100 * TIMES ) / ( EndTime - StartTime ) << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ uCalibrate.cc" //
// End: //
