//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 1994
// 
// RWEx1.cc -- Readers and Writer Problem
// 
// Author           : Peter A. Buhr
// Created On       : Thu Aug  2 11:51:34 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Nov 30 08:41:15 2005
// Update Count     : 95
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_Monitor ReaderWriter {
	int ReadCount, WriteUsage;
	uCondition ReaderAndWriter;
	enum RW { READER, WRITER };
  public:
	ReaderWriter() {
		ReadCount = WriteUsage = 0;
	} // ReaderWriter

	void StartRead() {
		if ( WriteUsage || ! ReaderAndWriter.empty() ) {
			ReaderAndWriter.wait( READER );
		} // if
		ReadCount += 1;
		if ( ! ReaderAndWriter.empty() && ReaderAndWriter.front() == READER ) {
			ReaderAndWriter.signal();
		} // if
	} // ReaderWriter::StartRead

	void EndRead() {
		ReadCount -= 1;
		if ( ReadCount == 0 ) {
			ReaderAndWriter.signal();
		} // if
	} // ReaderWriter::EndRead

	void StartWrite() {
		if ( WriteUsage || ReadCount != 0 ) {
			ReaderAndWriter.wait( WRITER );
		} // if
		WriteUsage = 1;
	} // ReaderWriter::StartWrite

	void EndWrite() {
		WriteUsage = 0;
		ReaderAndWriter.signal();
	} // ReaderWriter::EndWrite
}; // ReaderWriter


volatile int SharedVar = 0;								// shared variable to test readers and writers

_Task Worker {
	ReaderWriter &rw;

	void main() {
		yield( rand() % 100 );							// don't all start at the same time
		if ( rand() % 100 < 70 ) {						// decide to be a reader or writer
			rw.StartRead();
			osacquire( cout ) << "Reader:" << this << ", shared:" << SharedVar << endl;
			yield( 3 );
			rw.EndRead();
		} else {
			rw.StartWrite();
			SharedVar += 1;
			osacquire( cout ) << "Writer:" << this << ",  wrote:" << SharedVar << endl;
			yield( 1 );
			rw.EndWrite();
		} // if
	} // Worker::main
  public:
	Worker( ReaderWriter &rw ) : rw( rw ) {
	} // Worker::Worker
}; // Worker

#define MaxTask 50

void uMain::main() {
	ReaderWriter rw;
	Worker *workers;
	
	workers = new Worker[MaxTask]( rw );
	delete [] workers;

	osacquire( cout ) << "successful completion" << endl;
} // uMain::main


// Local Variables: //
// tab-width: 4 //
// compile-command: "u++ RWEx1.cc" //
// End: //
