//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 1999
// 
// ServerUNIX2.cc -- Server for UNIX/datagram socket test. Server reads data
// from multiple clients. The server reads the data from the client and writes
// it back.
// 
// Author           : Peter A. Buhr
// Created On       : Fri Apr 30 16:36:18 1999
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Sep  2 09:22:17 2006
// Update Count     : 30
// 

#include <uC++.h>
#include <uSocket.h>
#include <iostream>
using std::cerr;
using std::osacquire;
using std::endl;

#define EOD '\377'
#define BufferSize (8 * 1024)

_Task reader {
    uSocketServer &server;

    void main() {
		uDuration timeout( 10, 0 );						// timeout for read
		char buf[BufferSize];
		int len;

		try {
			for ( ;; ) {
				len = server.recvfrom( buf, sizeof(buf), 0, &timeout );
				// osacquire( cerr ) << "Server::reader read len:" << len << endl;
			  if ( len == 0 ) uAbort( "(uSocketServer &)0x%p : EOF ecountered without EOD", &server );
				server.sendto( buf, len );				// write byte back to client
			} // for
		} catch( uSocketServer::ReadTimeout ) {
		} // try
    } // reader::main
  public:
    reader( uSocketServer &server ) : uBaseTask( 64000 ), server( server ) {
    } // reader::reader
}; // reader

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		cerr << "Usage: " << argv[0] << " socket-name" << endl;
		exit( -1 );
	} // switch

	uSocketServer server( argv[1], SOCK_DGRAM );		// create and bind a server socket
	{
		reader rd( server );							// execute until EOD
	}
} // uMain

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Server ServerUNIX2.cc" //
// End: //
