//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr 1998
// 
// EHM6.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Tue Oct 27 21:24:48 1998
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Nov 21 15:25:45 2005
// Update Count     : 25
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;

_ResumeEvent R1 {
  public:
	int &i; char &c;
	R1( int &i, char &c ) : i( i ), c( c ) {}
};

_ResumeEvent R2 {};


class fred {
  public:
	void f( int x, char y ) {
		osacquire( cout ) << "enter f, x:" << x << " y:" << y << endl;
		_Resume R2();
		osacquire( cout ) << "exit f, x:" << x << " y:" << y << endl;
	}
	void g( int &x, char &y ) {
		osacquire( cout ) << "enter g, x:" << x << " y:" << y << endl;
		_Resume R1( x, y );
		osacquire( cout ) << "exit g, x:" << x << " y:" << y << endl;
	}
};

void rtn1( R1 &r ) {
	osacquire( cout ) << "rtn1" << endl;
	r.i = 1; r.c = 'b';
}

struct Rtn2 {
	int &i; char &c;
	Rtn2( int &i, char &c ) : i( i ), c( c ) {}
	void operator()( R2 &r ) {
		osacquire( cout ) << "rtn2, i:" << i << " c:" << c << endl;
		i = 2; c = 'c';									// change x, y
	}
};


void uMain::main() {
	fred ff, gg;

	try <R1,rtn1> {
		int x = 0;
		char y = 'a';
		Rtn2 rtn2( x, y );								// closure for locals

		ff.g( x, y );
		osacquire( cout ) << "try<R1,rtn1> x:" << x << " y:" << y << endl;

		// Check multiple handlers, only one is used.
		try <R1><gg.R2,rtn2> {
			gg.f( x, y );
			osacquire( cout ) << "try<R2,rtn2>, x:" << x << " y:" << y << endl;
		} // try
		try <R1><R2,rtn2> {								// R1 empty handler
			ff.g( x, y );
			osacquire( cout ) << "try<R1>, x:" << x << " y:" << y << endl;
		} // try
	} // try
}

// Local Variables: //
// tab-width: 4 //
// End: //
