//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.4.0, Copyright (C) Peter A. Buhr and Richard Bilson 2003
// 
// AbortExit.cc -- 
// 
// Author           : Peter A. Buhr
// Created On       : Fri Dec 19 10:33:58 2003
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Sep  8 15:55:23 2006
// Update Count     : 10
// 

#include <uC++.h>
#include <uSemaphore.h>
#include <iostream>
using std::cerr;
using std::endl;

enum Mode { SPIN, EXIT, UABORT, EXPLODE, ABORT, ASSERT } mode;

_Task worker {
    void main() {
        switch( mode ) {
          case SPIN:
	    for ( ;; ) {}
	  case EXIT:
	    exit( 3 );
	  case UABORT:
	    uAbort( "worker %d %s", 3, "text" );
	  case EXPLODE:
	    kill( getpid(), SIGILL );
	    for ( ;; ) {}				// delay until signal delivered to some kernel thread
	  case ABORT:
	    abort();
	  case ASSERT:
	    assert( false );
	} // switch
 	// CONTROL NEVER REACHES HERE!
    } // main
  public:
    worker( uCluster &c ) : uBaseTask( c ) {}
}; // worker

void uMain::main() {
    if ( argc <= 1 ) {
        cerr << "usage: " << argv[0] << " [0-3]" << endl;
    } // if
    mode = (Mode)atoi( argv[1] );

    uCluster c;
    uProcessor p(c);
    worker t(c);
    uSemaphore s(0);
    s.P();
} // uMain::main
