//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Russell Mok 1997
// 
// uEHM.h -- 
// 
// Author           : Russell Mok
// Created On       : Mon Jun 30 16:46:18 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Sep 18 12:18:05 2007
// Update Count     : 324
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __U_EHM_H__
#define __U_EHM_H__

#include <typeinfo>
#include "unwind-cxx.h"					// include file copied from gcc 3.4, needed for reraise from a catch-any, and for pthread cleanup

#define uRendezvousAcceptor uSerialMemberInstance.uAcceptor
#define uEHMMaxMsg 156
#define uEHMMaxName 100

class uBaseEvent;					// forward declaration


//######################### uEHM ########################


class uEHM {
    friend class uKernelBoot;				// access: terminateHandler, unexpectedHandler
    friend class uMachContext;				// access: terminate
    friend class uBaseCoroutine;			// access: ResumeWorkHorseInit, uResumptionHandlers, uDeliverEStack, unexpected, strncpy
    friend class uBaseTask;				// access: terminateHandler
    friend class uBaseEvent;				// access: AsyncEMsg

    class ResumeWorkHorseInit;
    class AutoResourceCleanup;
    class AsyncEMsg;
    class AsyncEMsgBuffer;

    static bool match_exception_type( const std::type_info *derived_type, const std::type_info *parent_type );
    static bool deliverable_exception( const std::type_info *event_type );
    static void terminate() __attribute__(( noreturn ));
    static void terminateHandler() __attribute__(( noreturn ));
    static void unexpected() __attribute__(( noreturn ));
    static void unexpectedHandler() __attribute__(( noreturn ));
  public:
    enum RaiseKind { ThrowRaise, ResumeRaise };

    class uResumptionHandlers;				// usage generated by translator
    template< typename Exn > class uNullHandlerClause;
    template< typename Exn, typename Functor > class uHandlerClause;
    class uAnyHandlerClause;

    class uHandlerBase;
    class uDeliverEStack;

    static void asyncToss( const uBaseEvent &ex, uBaseCoroutine &target, RaiseKind raiseKind, bool rethrow = false );
    static void asyncReToss( uBaseCoroutine &target, RaiseKind raiseKind );

    static void Throw( const uBaseEvent &ex );
    static void Throw( const uBaseEvent &ex, uBaseCoroutine &target ) {
	asyncToss( ex, target, ThrowRaise );
    } // uEHM::Throw
    static void Throw( uBaseCoroutine &target ) {	// asynchronous rethrow
	asyncReToss( target, ThrowRaise );
    } // uEHM::Throw
    static void ReThrow() __attribute__(( noreturn ));

    static void Resume( const uBaseEvent &ex );
    static void Resume( const uBaseEvent &ex, uBaseCoroutine &target ) {
	asyncToss( ex, target, ResumeRaise );
    } // uEHM::Resume
    static void Resume( uBaseCoroutine &target ) {	// asynchronous reresume
	asyncReToss( target, ResumeRaise );
    } // uEHM::Resume
    static void ReResume();

    static bool pollCheck();
    static bool poll();
    static const std::type_info *getTopResumptionType();
    static uBaseEvent *getCurrentException();
    static uBaseEvent *getCurrentResumption();
    static char *getCurrentEventName( RaiseKind raiseKind, char *s1, size_t n );
    static char *strncpy( char *s1, const char *s2, size_t n );
  private:
    static void resumeWorkHorse( const uBaseEvent &, const bool );
}; // uEHM


//######################### uEHM::AsyncEMsg ########################


class uEHM::AsyncEMsg : public uSeqable {
    friend class uEHM;
    friend class uEHM::AsyncEMsgBuffer;
    friend void uEHM::Throw( const uBaseEvent &, uBaseCoroutine & );
    friend void uEHM::Resume( const uBaseEvent &, uBaseCoroutine & );
    friend bool uEHM::poll();

    bool hidden;
    uBaseEvent *asyncEvent;

    AsyncEMsg &operator=( const AsyncEMsg & );
    AsyncEMsg( const AsyncEMsg & );

    AsyncEMsg( const uBaseEvent &ex );
  public:
    ~AsyncEMsg();
}; // uEHM::AsyncEMsg


//######################### uEHM::AsyncEMsgBuffer ########################


// AsyncEMsgBuffer looks like public uQueue<AsyncEMsg> but with mutex

class uEHM::AsyncEMsgBuffer : public uSequence<uEHM::AsyncEMsg> {
    friend bool uEHM::poll();				// access lock
    friend class uTaskMain;
    friend class uCoroutineMain;

    AsyncEMsgBuffer( const AsyncEMsgBuffer & );
    AsyncEMsgBuffer& operator=( const AsyncEMsgBuffer & );
  public:
    uSpinLock lock;
    AsyncEMsgBuffer();
    ~AsyncEMsgBuffer();
    void uAddMsg( AsyncEMsg *msg );
    AsyncEMsg *uRmMsg();
    AsyncEMsg *uRmMsg( AsyncEMsg *msg );
    AsyncEMsg *nextVisible( AsyncEMsg *msg );
}; // uEHM::AsyncEMsgBuffer


//######################### uBaseEvent ########################


class uBaseEvent {
    friend class uEHM;
    friend class uEHM::AsyncEMsg;
    friend void uEHM::Throw( const uBaseEvent &, uBaseCoroutine & );
    friend void uEHM::Throw( const uBaseEvent & );
    friend void uEHM::Resume( const uBaseEvent &, uBaseCoroutine & );
    friend void uEHM::Resume( const uBaseEvent & );
    friend bool uEHM::poll();
    friend void uEHM::resumeWorkHorse( const uBaseEvent &, const bool );
  protected:
    mutable uEHM::RaiseKind raiseKind;			// how the exception is raised
    const uBaseCoroutine *src;				// set at raise
    char srcName[uEHMMaxName];
    char msg[uEHMMaxMsg];

    mutable const void *staticallyBoundObject;

    uBaseEvent( const char *const msg = "" ) { setMsg( msg ); }
    void setSrc( uBaseCoroutine &coroutine );
    const std::type_info *getEventType() const { return &typeid( *this ); };
    void setMsg( const char *const msg );
    virtual void stackThrow() const = 0;		// translator generated => object specific
  public:
    virtual ~uBaseEvent();

    const char *message() const { return msg; }
    const uBaseCoroutine &source() const { return *src; }
    const char *sourceName() const { return src != NULL ? srcName : "*unnamed*"; }
    uEHM::RaiseKind getRaiseKind() const { return raiseKind; }
    void reraise() const;
    virtual uBaseEvent *duplicate() const = 0;		// translator generated => object specific
    virtual void defaultTerminate() const;
    virtual void defaultTerminate();
    virtual void defaultResume() const;
    virtual void defaultResume();

    // These members should be private but cannot be because they are
    // referenced from user code.

    const void *getOriginalThrower() const { return staticallyBoundObject; }
    const uBaseEvent &setOriginalThrower( const void *p ) const;

    void Resume() const { uEHM::Resume( *this ); }
    void Resume( uBaseCoroutine &target ) const { uEHM::Resume( *this, target ); }

    void Throw () const { uEHM::Throw( *this ); }
    void Throw ( uBaseCoroutine &target ) const { uEHM::Throw( *this, target ); }
}; // uBaseEvent


//######################### internal class and function declarations ########################


// base class allowing a list of otherwise-heterogeneous uHandlerClauses
class uEHM::uHandlerBase {
    void *const matchBinding;
    const std::type_info *eventType;
  protected:
    uHandlerBase( void *matchBinding, const std::type_info *eventType ) : matchBinding( matchBinding ), eventType( eventType ) {}
    virtual ~uHandlerBase() {}
  public:
    virtual void uHandler( uBaseEvent &exn ) = 0;
    void *getMatchBinding() const { return matchBinding; }
    const std::type_info *getEventType() const { return eventType; }
}; // uHandlerBase

template< typename Exn >
class uNullHandlerClause : public uEHM::uHandlerBase {
  public:
    uNullHandlerClause( void *originalThrower ) : uHandlerBase( originalThrower, &typeid( Exn ) ) {}
    virtual void uHandler( uBaseEvent &exn ) {}
}; // uNullHandlerClause

template< typename Exn, typename Functor >
class uHandlerClause : public uEHM::uHandlerBase {
    Functor &functor;
  public:
    uHandlerClause( void *originalThrower, Functor &functor ) : uHandlerBase( originalThrower, &typeid( Exn ) ), functor( functor ) {}
    virtual void uHandler( uBaseEvent &exn ) { functor( (Exn &)exn ); }
}; // uHandlerClause

// handlers for try < ... >

template< typename Functor >
class uAnyHandlerClause : public uEHM::uHandlerBase {
    Functor &functor;
  public:
    uAnyHandlerClause( void *dummy, Functor &functor ) : uHandlerBase ( 0, 0 ), functor( functor ) {}; // no binding possible, no id address either
    virtual void uHandler( uBaseEvent & ) { functor(); } // NOTE: functor operator has no parameters
}; // uAnyHandlerClause

class uAnyNullHandlerClause : public uEHM::uHandlerBase {
   public:
    uAnyNullHandlerClause( void *dummy ) : uHandlerBase ( 0, 0 ) {}; // no binding possible, no id address either
    virtual void uHandler( uBaseEvent & ) {}
}; // uAnyNullHandlerClause


// Every set of resuming handlers bound to a template try block is saved in a
// uEHM::uResumptionHandlers object. The resuming handler hierarchy is
// implemented as a linked list.

class uEHM::uResumptionHandlers {
    friend void uEHM::resumeWorkHorse( const uBaseEvent &, const bool );

    uResumptionHandlers *next, *conseqNext;		// uNext maintains a proper stack, while uConseqNext is used to skip
							// over handlers that have already been examined for resumption (to avoid recursion)

    const unsigned int size;				// number of handlers
    uHandlerBase *const *table;				// pointer to array of resumption handlers

    uResumptionHandlers( const uResumptionHandlers & );	// no copy
    uResumptionHandlers &operator=( const uResumptionHandlers & ); // no assignment
  public:
    uResumptionHandlers( uHandlerBase *const table[], const unsigned int size );
    ~uResumptionHandlers();
}; // uEHM::uResumptionHandlers


// The following actually implements a linked list of event_id's table.  Used
// in enable and disable block.

class uEHM::uDeliverEStack {
    friend bool uEHM::deliverable_exception( const std::type_info * );

    uDeliverEStack *next;
    bool deliverFlag;					// true when events in table is Enable, otherwise false
    int  table_size;                                    // number of events in the table, 0 implies everything
    const std::type_info **event_table;			// event id table

    uDeliverEStack( uDeliverEStack & );			// no copy
    uDeliverEStack &operator=( uDeliverEStack & );	// no assignment
  public:
    uDeliverEStack( bool f, const std::type_info **t = NULL, unsigned int msg = 0 ); // for enable and disable blocks
    ~uDeliverEStack();
}; // uEHM::uDeliverEStack


#endif // __U_EHM_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
