//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 1994
// 
// uAbortExit.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Fri Oct 26 11:54:31 1990
// Last Modified By : Peter A. Buhr
// Last Modified On : Sun Sep 23 18:10:41 2007
// Update Count     : 508
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#define __U_PROFILE__
#define __U_PROFILEABLE_ONLY__


#include <uC++.h>
#include <uProfiler.h>
//#include <uDebug.h>

extern void uDebugWrite( char *buffer, int len );

#include <cstdio>
#include <cstdarg>
#include <cerrno>
#include <unistd.h>					// _exit


void uKernelModule::abortExit() {
    // Deal with any starting processors spinning to get onto the global
    // processor list.

    uKernelModule::globalProcessorLock->acquire();	// never released again
    uKernelModule::globalSpinAbort = true;

    // Destory any remaining processors.

    uProcessorDL *pr;
    for ( uSeqIter<uProcessorDL> iter(*uKernelModule::globalProcessors); iter >> pr; ) {
	if ( &(pr->processor()) != &uThisProcessor() ) { // do not kill current processor
#ifdef __U_DEBUG_H__
	    // cannot call uDebugPrt because spinlocks cause termination after globalSpinAbort is set.
	    fprintf( stderr, "abortExit(), killing processor 0x%p / process %d\n", &(pr->processor()), pr->processor().getPid() );
#endif // __U_DEBUG_H__
	    kill( pr->processor().getPid(), SIGKILL );
	} // if
    } // for
} // uKernelModule::abortExit


#if defined( __irix__ )
extern "C" void __do_global_dtors();
extern "C" void _exithandle();
extern "C" void _cleanup();
#endif // __irix__

void exit( int retcode ) __THROW {
    uKernelModule::inExit = true;
    uKernelModule::retCode = retcode;

#if defined( __freebsd__ )
    bool wasInExit = uKernelModule::inExit;

    // freebsd's _start calls exit to invoke global destructors
    if ( uKernelModule::afterMain && ! wasInExit ) {
	((void (*)(int))uKernelModule::interposeSymbol( "exit" ))( retcode ); // call the real exit
    } // if
#endif // __freebsd__

#if defined( __U_MULTI__ ) && ! defined( __solaris__ ) && ! defined( __U_PTHREAD__ ) // all SUN lwps are terminated by exit/abort
    // Only the root processor can return a value to the shell so it is
    // necessary to migrate to the system processor to exit with a return code.
    // Also exit is not called in the kernel because it blocks.

    if ( &uThisProcessor() != uKernelModule::systemProcessor ) {
	uKernelModule::systemProcessor->procExit( retcode );
	// CONTROL NEVER REACHES HERE!
	assert( false );
    } else {
	uKernelModule::abortExit();                     // shut down other processors
#if defined( __irix__ )
	if ( ! uKernelModule::afterMain ) {
	    _exithandle();				// atexit functions
	    // This next line causes abnormal termination
	    //_cleanup();                                     // close files
	    __do_global_dtors();			// global destructors
	} // if
	_exit( retcode );
#else
	if ( uKernelModule::afterMain ) {
	    // destructors already started, don't risk restarting them
	    _exit( retcode );
	} else {
	    ((void (*)(int))uKernelModule::interposeSymbol( "exit" ))( retcode ); // call the real exit
	} // if
#endif // __irix__
	// CONTROL NEVER REACHES HERE!
	assert( false );
    } // if
#else
    ((void (*)(int))uKernelModule::interposeSymbol( "exit" ))( retcode ); // call the real exit
    // CONTROL NEVER REACHES HERE!
    assert( false );
#endif
} // exit


void uExit( int retcode ) {
    exit( retcode );
} // uExit


// Only one processor should call abort and succeed.  Once a processor calls
// abort, all other processors quietly exit while the aborting processor cleans
// up the system and possibly dumps core.

void uAbort( const char *fmt, ... ) {
    uKernelModule::globalAbort = true;
    uBaseTask &task = uThisTask();			// optimization

    // uAbort cannot be recursively entered by the same or different processors
    // because all signal handlers return when the globalAbort flag is true.
#if defined( __U_MULTI__ )
    if ( ! uKernelModule::globalAbortLock->tryacquire() ) { // not the first task to abort ?
	sigset_t mask;
	sigemptyset( &mask );
	sigaddset( &mask, SIGALRM );			// block SIGALRM signals
	sigaddset( &mask, SIGUSR1 );			// block SIGUSR1 signals
	sigsuspend( &mask );				// block the processor to prevent further damage during abort
	_exit( -1 );					// if processor unblocks before it is killed, terminate it
    } // if
#endif // __U_MULTI__

    // profiling

    task.profileInactivate();				// make sure the profiler is not called from this point on

    // Turn off uOwnerLock checking.

    uKernelModule::initialization = false;
    static char helpText[1024];
    int len;

    if ( fmt != NULL ) {
	// Display the relevant shut down information.

	len = sprintf( helpText, "uC++ Runtime error (UNIX pid:%ld) ", (long int)getpid() ); // use UNIX pid (versus getPid)
	uDebugWrite( helpText, len );
	va_list args;
	va_start( args, fmt );
	len = vsnprintf( helpText, 1024, fmt, args );
	va_end( args );
	uDebugWrite( helpText, len );
	helpText[0] = '\n';
	uDebugWrite( helpText, 1 );
    } // if

    len = sprintf( helpText, "Error occurred while executing task %.256s (0x%p)", task.getName(), &task );
    uDebugWrite( helpText, len );
    if ( &task != &uThisCoroutine() ) {
	len = sprintf( helpText, " in coroutine %.256s (0x%p).\n", uThisCoroutine().getName(), &uThisCoroutine() );
	uDebugWrite( helpText, len );
    } else {
	helpText[0] = '.'; helpText[1] = '\n';
	uDebugWrite( helpText, 2 );
    } // if

    // In debugger mode, tell the global debugger to stop the application.

#if __U_LOCALDEBUGGER_H__
    if ( ! THREAD_GETMEM( disableInt ) && ! THREAD_GETMEM( disableIntSpin ) ) {
	if ( uLocalDebugger::uLocalDebuggerActive ) uLocalDebugger::uLocalDebuggerInstance->abortApplication();
    } // if
#endif // __U_LOCALDEBUGGER_H__

    // Try to shut down other processors.

#if defined( __U_MULTI__ ) && ! ( defined( __solaris__ ) || defined( __U_PTHREAD__ ) ) // SUN lwps and pthread KT are terminated by exit/abort
    uKernelModule::abortExit();				// shut down other processors
#endif

    // After having killed off the other processors, dump core if required,
    // otherwise, quietly call "_exit". Cannot call "exit" because of global
    // destructors.

    if ( ! uKernelModule::coreDumped ) {		// child process may have failed and dumped core already
	uKernelModule::coreDumped = true;		// prevent other UNIX processes from dumping core
#if defined( __linux__ ) && ! defined( __U_PTHREAD__ )
	// Use UNIX getpid (versus processor getPid) to terminate the process group.
	kill( getpid(), SIGABRT );			// "abort()" may call "raise(SIGABRT)" to NPTL thread
#else
	((void (*)())uKernelModule::interposeSymbol( "abort" ))(); // call the real abort
#endif
    } // if

    _exit( -1 );
} // uAbort


void abort() {
    uAbort( NULL );
} // uAbort


// Local Variables: //
// compile-command: "gmake install" //
// End: //
