//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 1994
// 
// Migrate.cc -- Test migrating of tasks among clusters.
// 
// Author           : Peter Buhr
// Created On       : Tue Jun 28 10:23:11 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Tue Jun 26 11:55:26 2007
// Update Count     : 94
// 

#include <uC++.h>
#include <iostream>
using std::cout;
using std::endl;

#define NoOfClusters 3

unsigned int uDefaultPreemption() {
    return 1;
} // uDefaultPreemption

unsigned int uDefaultSpin() {
    return 1000;
} // uDefaultSpin

_Task Worker {
    int id;
    uCluster **clusters;

    void main() {
	const int NoOfTimes = 10000;
	char name[20];
	sprintf( name, "Worker%d", id );
	setName( name );

        for ( int i = 0; i < NoOfTimes; i += 1 ) {
	    for ( int j = 0; j < NoOfClusters; j += 1, id = (id + 1) % NoOfClusters ) {
		migrate( *(clusters[id]) );
	    } // for
        } // for
    } // Worker::main
  public:
    Worker( int id, uCluster &create, uCluster *clusters[] ) : uBaseTask( create ), id( id ), clusters( clusters ) {
    } // Worker::Worker
}; // Worker


void uMain::main() {
    const int NoOfTasks = 3;

    uCluster *clusters[NoOfClusters];
    uProcessor *procesosrs[NoOfClusters];
    Worker *tasks[NoOfTasks];
    int i, j;

    clusters[0] = &uThisCluster();			// default cluster and processor
    procesosrs[0] = &uThisProcessor();

    for ( i = 1; i < NoOfClusters; i += 1 ) {		// create N-1 clusters and processors
	clusters[i] = new uCluster();
	procesosrs[i] = new uProcessor( *(clusters[i]) );
    } // for

    for ( i = 0, j = 0; i < NoOfTasks; i += 1, j = (j + 1) % NoOfClusters ) { // create tasks
	tasks[i] = new Worker( j, *(clusters[j]), clusters );
    } // for
    for ( i = 0; i < NoOfTasks; i += 1 ) {		// delete tasks
	delete tasks[i];
    } // for

    for ( i = 1; i < NoOfClusters; i += 1 ) {		// delete N-1 clusters and processors
	delete procesosrs[i];
	delete clusters[i];
    } // for

    cout << "successful completion" << endl;
} // uMain::main

// Local Variables: //
// compile-command: "u++ Migrate.cc" //
// End: //
