//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 1994
// 
// ClientINET.cc -- Client for INET/stream socket test. Client reads from
// standard input, writes the data to the server, reads the data from the
// server, and writes that data to standard output.
// 
// Author           : Peter A. Buhr
// Created On       : Tue Jan  7 08:42:32 1992
// Last Modified By : Peter A. Buhr
// Last Modified On : Sat Sep  2 09:19:04 2006
// Update Count     : 143
// 

#include <uC++.h>
#include <uSocket.h>
#include <iostream>
using std::cin;
using std::cout;
using std::cerr;
using std::osacquire;
using std::endl;

#define EOD '\377'
// minimum buffer size is 2, 1 character and string terminator, '\0'
#define BufferSize (65)

int rcnt = 0, wcnt = 0;

_Task reader {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];
		int len;

		for ( ;; ) {
			len = client.read( buf, sizeof(buf) );
			// osacquire( cerr ) << "Client::reader read len:" << len << endl;
		  if ( len == 0 ) uAbort( "(uSocketClient &)0x%p : EOF ecountered without EOD", &client );
			// The EOD character can be piggy-backed onto the end of the message.
		  if ( buf[len - 1] == EOD ) {
			  rcnt += len - 1;
			  cout.write( buf, len - 1 );				// do not write the EOD
			  break; }
			rcnt += len;
			cout.write( buf, len );
		} // for
	} // reader::main
  public:
	reader( uSocketClient &client ) : client ( client ) {
	} // reader::reader
}; // reader

_Task writer {
	uSocketClient &client;

	void main() {
		char buf[BufferSize];

		for ( ;; ) {
			cin.get( buf, sizeof(buf), '\0' );			// leave room for string terminator
			int len = strlen( buf );
			// osacquire( cerr ) << "Client::writer read len:" << len << endl;
		  if ( buf[0] == '\0' ) break;
			wcnt += len;
			client.write( buf, len );
		} // for
		buf[0] = EOD;
		client.write( buf, sizeof(char) );
	} // writer::main
  public:
	writer( uSocketClient &client ) : client( client ) {
	} // writer::writer
}; // writer

void uMain::main() {
	switch ( argc ) {
	  case 2:
		break;
	  default:
		cerr << "Usage: " << argv[0] << " port-number" << endl;
		exit( -1 );
	} // switch

	uSocketClient client( atoi( argv[1] ) );			// connection to server
	{
		reader rd( client );							// emit worker to read from server and write to output
		writer wr( client );							// emit worker to read from input and write to server
	}
	if ( wcnt != rcnt ) {
		uAbort( "not all data transfered\n" );
	} // if
} // uMain::main

// Local Variables: //
// tab-width: 4 //
// compile-command: "u++-work -o Client ClientINET.cc" //
// End: //
