//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Peter A. Buhr 1997
// 
// EHM1.cc -- testing exception handling mechanism
// 
// Author           : Peter A. Buhr
// Created On       : Wed Nov 26 23:06:25 1997
// Last Modified By : Peter A. Buhr
// Last Modified On : Fri Feb  2 15:28:44 2007
// Update Count     : 249
// 


#include <uC++.h>
#include <iostream>
using std::cout;
using std::osacquire;
using std::endl;


//######################### uBaseCoroutine::uFailure #########################


_Event xxx {
  public:
    xxx( const char *const msg ) : uBaseEvent( msg ) {}
};

_Event yyy {
  public:
    yyy( const char *msg ) { setMsg( msg ); }
};

_Coroutine CoroutineDummy1 {
    bool res;
    void main() {
	if ( res ) {
	    _Resume yyy( "resume test" );
	} else {
	    _Throw xxx( "throw test" );
	} // if
    } // CoroutineDummy1::main
  public:
    CoroutineDummy1( bool r ) : res( r ) {}
    void mem() { resume(); }
}; // CoroutineDummy1

_Coroutine CoroutineDummy2 {
    void main() {
	CoroutineDummy1 dummy1( false );
	dummy1.mem();
    } // CoroutineDummy1::main
  public:
    void mem() { resume(); }
}; // CoroutineDummy1


//######################### uCondition::uWaitingFailure #########################


_Task TaskDummy1 {
    uCondition x;
  public:
    void mem() {
	x.wait();
    } // TaskDummy1::mem
  private:
    void main() {
	_Accept( mem );
    } // TaskDummy1::main
}; // TaskDummy1

_Task TaskDummy2 {
    TaskDummy1 &t1;

    void main() {
#if 0
	t1.mem();
#endif
	try {
	    t1.mem();
	} catch( uCondition::WaitingFailure &ex ) {
	    osacquire( cout ) << "handled exception uCondition::WaitingFailure : task " << ex.source().getName() << " (" << &(ex.source()) << ") found blocked task" << " " << uThisTask().getName() << " (" << &uThisTask() << ") on condition variable " << &ex.conditionId() << endl << endl;
	} // try
    } // TaskDummy2::main
  public:
    TaskDummy2( TaskDummy1 &t1 ) : t1( t1 ) {}
}; // TaskDummy2


//######################### uSerial::uRendezvousFailure #########################


_Task TaskDummy3 {
    uBaseTask &t;
  public:
    TaskDummy3( uBaseTask &t ) : t( t ) {}
    void mem() {
    } // TaskDummy3::mem
  private:
    void main() {
	_Throw xxx( "test" ) _At t;
#if 0
	_Accept( mem );
#endif
	try {
	    _Accept( mem );
	} catch ( uSerial::RendezvousFailure &ex ) {
	    osacquire( cout ) << "handled exception uSerial::RendezvousFailure : accepted call fails from task " << ex.sourceName() << " (" << &(ex.source()) << ") to mutex member of task " << uThisTask().getName() << " (" << &uThisTask() << ")" << endl << endl;
	} // try
    } // TaskDummy3::main
}; // TaskDummy3


//######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################


_Task TaskDummy4 {
    uCondition temp;
  public:
    void mem() {
	temp.wait();
    } // TaskDummy4::mem
  private:
    void main() {
	_Accept( mem );				// let TaskDummy5 in so it can wait
	temp.signal();					// put TaskDummy5 on A/S stack
	_Accept( ~TaskDummy4 );			// uMain is calling the destructor
    } // TaskDummy4::main
}; // TaskDummy4

_Task TaskDummy5 {
    TaskDummy4 &t4;
  public:
    TaskDummy5( TaskDummy4 &t4 ) : t4( t4 ) {}
  private:
    void main() {
#if 0
	t4.mem();
#endif
	try {
	    t4.mem();
	} catch( uSerial::EntryFailure &ex ) {
	    osacquire( cout ) << "handled exception uSerial::EntryFailure : while executing mutex destructor, task " << ex.source().getName() << " (" << &(ex.source()) << ") found task " << uThisTask().getName() << " (" << &uThisTask() << ") " << ex.message() << endl << endl;
	} catch( ... ) {
	    uAbort( "EHM1 error" );
	} // try
    } // TaskDummy5::main
}; // TaskDummy5


//######################### uSerial::uEntryFailure (entry queue) #########################


_Task TaskDummy6 {
  public:
    void mem() {
    } // TaskDummy6::mem
  private:
    void main() {
	_Accept( ~TaskDummy6 );
    } // TaskDummy6::main
};

_Task TaskDummy7 {
    TaskDummy6 &t6;
  public:
    TaskDummy7( TaskDummy6 &t6 ) : t6( t6 ) {}
  private:
    void main() {
#if 0
	t6.mem();
#endif
	try {
	    t6.mem();
	} catch( uSerial::EntryFailure &ex ) {
	    osacquire( cout ) << "handled exception uSerial::EntryFailure : while executing mutex destructor, task " << ex.source().getName() << " (" << &(ex.source()) << ") found task " << uThisTask().getName() << " (" << &uThisTask() << ") " << ex.message() << endl << endl;
	} catch( ... ) {
	    uAbort( "EHM1 error" );
	} // try
    } // TaskDummy7::main
}; // TaskDummy7

void unHandledHandler( uBaseCoroutine::UnhandledException & e ) {
    osacquire( cout ) << "Now triggering embedded UnhandledException" << endl;    
    e.triggerCause();
}


void uMain::main() {
    //######################### uBaseCoroutine::UnhandledException #########################
    {
	CoroutineDummy1 dummy1( true );

	try {
	    dummy1.mem();
	} catch( uBaseCoroutine::UnhandledException &ex ) {
	    osacquire( cout ) << "handled exception uBaseCoroutine::UnhandledException : in coroutine " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") raised non-locally from resumed coroutine " << ex.sourceName() << " (" << &(ex.source()) << "), which was terminated due to an " << ex.message() << endl << endl;
	    try <yyy> {
		ex.triggerCause();
		osacquire( cout ) << "after trigger" << endl;
	    } // try
	} catch( ... ) {
	    uAbort( "EHM1 error" );
	} // try
    }
    {
	CoroutineDummy2 dummy2;

	try {
	    dummy2.mem();
	} catch( uBaseCoroutine::UnhandledException &ex ) {
	    osacquire( cout ) << "handled exception uBaseCoroutine::UnhandledException : in coroutine " << uThisCoroutine().getName() << " (" << &uThisCoroutine() << ") raised non-locally from resumed coroutine " << ex.sourceName() << " (" << &(ex.source()) << "), which was terminated due to a series of unhandled exceptions -- originally " << ex.message() << " inside coroutine " << ex.origName() << " (" << &(ex.origSource()) << ")." << endl << endl;

	    osacquire( cout ) << "Now triggering exception" << endl;
	    try <uBaseCoroutine::UnhandledException, unHandledHandler> {
		ex.triggerCause();
	    } catch ( xxx &ex ) {
		osacquire( cout ) << "caught xxx : " << ex.message() << endl;
	    } catch ( ... ) {
		uAbort("EHM1 error");
	    } // try
	} catch( ... ) {
	    uAbort( "EHM1 error" );
	} // try
    }
    //######################### uCondition::uWaitingFailure #########################

    TaskDummy1 *t1 = new TaskDummy1;
    TaskDummy2 *t2 = new TaskDummy2( *t1 );
    delete t1;						// delete t1 with t2 blocked on condition variable
    delete t2;

    //######################### uSerial::uRendezvousFailure #########################
    {
	TaskDummy3 t3( uThisTask() );
	try {
	    _Enable {
		t3.mem();
	    } // _Enable
	} catch( xxx &ex ) {
	} catch( ... ) {
	    uAbort( "EHM1 error" );
	} // try
    }
    //######################### uSerial::uEntryFailure (acceptor/signalled stack) #########################

    TaskDummy4 *t4 = new TaskDummy4;
    TaskDummy5 *t5 = new TaskDummy5( *t4 );
    delete t4;
    delete t5;

    //######################### uSerial::uEntryFailure (entry queue) #########################

    TaskDummy6 *t6 = new TaskDummy6;
    TaskDummy7 *t7 = new TaskDummy7( *t6 );
    delete t6;
    delete t7;

    cout << "successful execution" << endl;
} // uMain::main
