//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.5.0, Copyright (C) Richard C. Bilson 2007
// 
// Atomic.cc -- 
// 
// Author           : Richard C. Bilson
// Created On       : Mon Sep 10 16:47:22 2007
// Last Modified By : Peter A. Buhr
// Last Modified On : Mon Sep 10 16:49:08 2007
// Update Count     : 2
// 

#include <uC++.h>
#include <iostream>
using namespace std;

#define NPROCS 8
#define NTASKS 8
#define NITER 10000000

_Task IncTester {
    volatile int &loc;
  public:
    IncTester( volatile int &loc_ ) : loc( loc_ ) {}

    void main() {
	for ( int i = 0; i < NITER; i += 1 ) {
	    uAtomicInc( loc );
	    uAtomicDec( loc );
	} // for
    } // IncTester::main
}; // IncTester

void uMain::main() {
    volatile int loc = 0;
    IncTester *testers[ NTASKS ];

    for ( int i = 0; i < NTASKS; i += 1 ) {
	testers[ i ] = new IncTester( loc );
    } // for
    for ( int i = 0; i < NTASKS; i += 1 ) {
	delete testers[ i ];
    } // for

    if ( loc == 0 ) {
	cout << "successful completion" << endl;
    } else {
	cout << "error: expected value 0, got value " << loc << endl;
    } // if
} // uMain::main
